%------------------------------------------------------------------------------
% File     : DAT170^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Huffman 1572
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Bla08] Blanchette (2008), The Textbook Proof of Huffman's Alg
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : huffman__1572.p [Bla16]

% Status   : Theorem
% Rating   : 0.33 v8.1.0, 0.50 v7.5.0, 0.67 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  362 (  84 unt;  66 typ;   0 def)
%            Number of atoms       :  862 ( 309 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4214 (  49   ~;  17   |;  36   &;3741   @)
%                                         (   0 <=>; 371  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   7 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  106 ( 106   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   67 (  64 usr;   5 con; 0-6 aty)
%            Number of variables   :  927 (  29   ^; 833   !;   7   ?; 927   :)
%                                         (  58  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:42:39.045
%------------------------------------------------------------------------------
%----Could-be-implicit typings (5)
thf(ty_t_Huffman__Mirabelle__gjololrwrm_Otree,type,
    huffma16452318e_tree: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (61)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__ring,type,
    ordered_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__semiring,type,
    ordered_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__semiring__0,type,
    ordered_semiring_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__comm__semiring,type,
    ordere1490568538miring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors__cancel,type,
    semiri1923998003cancel: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__monoid__add__imp__le,type,
    ordere516151231imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oalphabet,type,
    huffma505251170phabet: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OcachedWeight,type,
    huffma787811817Weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oconsistent,type,
    huffma1050891809istent: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ocost,type,
    huffma636208924e_cost: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Odepth,type,
    huffma223349076_depth: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ofreq,type,
    huffma854352999e_freq: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oheight,type,
    huffma1554076246height: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ooptimum,type,
    huffma936049440ptimum: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Osibling,type,
    huffma943100115ibling: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapLeaves,type,
    huffma2094459102Leaves: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat > A > nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapSyms,type,
    huffma469337550apSyms: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OuniteTrees,type,
    huffma453905539eTrees: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oweight,type,
    huffma691733767weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a2: a ).

thf(sy_v_b,type,
    b: a ).

thf(sy_v_t,type,
    t: huffma16452318e_tree @ a ).

%----Relevant facts (254)
thf(fact_0_assms_I1_J,axiom,
    huffma1050891809istent @ a @ t ).

% assms(1)
thf(fact_1_assms_I3_J,axiom,
    member @ a @ b @ ( huffma505251170phabet @ a @ t ) ).

% assms(3)
thf(fact_2_assms_I2_J,axiom,
    member @ a @ a2 @ ( huffma505251170phabet @ a @ t ) ).

% assms(2)
thf(fact_3_assms_I5_J,axiom,
    ord_less_eq @ nat @ ( huffma223349076_depth @ a @ t @ a2 ) @ ( huffma223349076_depth @ a @ t @ b ) ).

% assms(5)
thf(fact_4_assms_I4_J,axiom,
    ord_less_eq @ nat @ ( huffma854352999e_freq @ a @ t @ a2 ) @ ( huffma854352999e_freq @ a @ t @ b ) ).

% assms(4)
thf(fact_5_depth__swapSyms__neither,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,C: A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( C != A2 )
       => ( ( C != B )
         => ( ( huffma223349076_depth @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) @ C )
            = ( huffma223349076_depth @ A @ T @ C ) ) ) ) ) ).

% depth_swapSyms_neither
thf(fact_6_swapSyms__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma469337550apSyms @ A @ T @ A2 @ A2 )
        = T ) ) ).

% swapSyms_id
thf(fact_7__092_060open_062freq_At_Aa_A_K_Adepth_At_Ab_A_L_Afreq_At_Ab_A_K_Adepth_At_Aa_A_092_060le_062_Afreq_At_Aa_A_K_Adepth_At_Aa_A_L_Afreq_At_Ab_A_K_Adepth_At_Ab_092_060close_062,axiom,
    ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ a2 ) @ ( huffma223349076_depth @ a @ t @ b ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ b ) @ ( huffma223349076_depth @ a @ t @ a2 ) ) ) @ ( plus_plus @ nat @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ a2 ) @ ( huffma223349076_depth @ a @ t @ a2 ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ b ) @ ( huffma223349076_depth @ a @ t @ b ) ) ) ).

% \<open>freq t a * depth t b + freq t b * depth t a \<le> freq t a * depth t a + freq t b * depth t b\<close>
thf(fact_8_alphabet__swapSyms,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,B: A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
       => ( ( huffma505251170phabet @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) )
          = ( huffma505251170phabet @ A @ T ) ) ) ) ).

% alphabet_swapSyms
thf(fact_9_cost__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
            = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ B ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) ) ) ) ).

% cost_swapSyms
thf(fact_10_freq__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( huffma854352999e_freq @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) )
            = ( huffma854352999e_freq @ A @ T ) ) ) ) ) ).

% freq_swapSyms
thf(fact_11_consistent__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) ) ) ).

% consistent_swapSyms
thf(fact_12_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
          = ( B = C ) ) ) ).

% add_left_cancel
thf(fact_13_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
          = ( B = C ) ) ) ).

% add_right_cancel
thf(fact_14_add__mult__distrib,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( times_times @ nat @ ( plus_plus @ nat @ M @ N ) @ K )
      = ( plus_plus @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) ) ) ).

% add_mult_distrib
thf(fact_15_add__mult__distrib2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( times_times @ nat @ K @ ( plus_plus @ nat @ M @ N ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) ) ) ).

% add_mult_distrib2
thf(fact_16_left__add__mult__distrib,axiom,
    ! [I: nat,U: nat,J: nat,K: nat] :
      ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U ) @ K ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ ( plus_plus @ nat @ I @ J ) @ U ) @ K ) ) ).

% left_add_mult_distrib
thf(fact_17_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
          = ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_cancel_right
thf(fact_18_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
          = ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_cancel_left
thf(fact_19_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_20_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_21_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_22_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_23_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_24_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_25_add__le__imp__le__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_imp_le_right
thf(fact_26_add__le__imp__le__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_imp_le_left
thf(fact_27_le__iff__add,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B2: A] :
            ? [C2: A] :
              ( B2
              = ( plus_plus @ A @ A3 @ C2 ) ) ) ) ) ).

% le_iff_add
thf(fact_28_add__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add_right_mono
thf(fact_29_add__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) ) ) ) ).

% add_left_mono
thf(fact_30_add__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ D ) ) ) ) ) ).

% add_mono
thf(fact_31_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_32_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_33_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_34_nat__le__iff__add,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
        ? [K2: nat] :
          ( N2
          = ( plus_plus @ nat @ M2 @ K2 ) ) ) ) ).

% nat_le_iff_add
thf(fact_35_trans__le__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_36_trans__le__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_37_add__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_38_add__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_le_mono
thf(fact_39_le__Suc__ex,axiom,
    ! [K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ K @ L )
     => ? [N3: nat] :
          ( L
          = ( plus_plus @ nat @ K @ N3 ) ) ) ).

% le_Suc_ex
thf(fact_40_add__leD2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ K @ N ) ) ).

% add_leD2
thf(fact_41_add__leD1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% add_leD1
thf(fact_42_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ M @ N ) ) ).

% le_add2
thf(fact_43_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ N @ M ) ) ).

% le_add1
thf(fact_44_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq @ nat @ M @ N )
         => ~ ( ord_less_eq @ nat @ K @ N ) ) ) ).

% add_leE
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B3: $tType,A: $tType,F: A > B3,G: A > B3] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_mult__le__mono2,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ K @ I ) @ ( times_times @ nat @ K @ J ) ) ) ).

% mult_le_mono2
thf(fact_50_mult__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K ) @ ( times_times @ nat @ J @ K ) ) ) ).

% mult_le_mono1
thf(fact_51_mult__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K ) @ ( times_times @ nat @ J @ L ) ) ) ) ).

% mult_le_mono
thf(fact_52_le__square,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ M ) ) ).

% le_square
thf(fact_53_le__cube,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ ( times_times @ nat @ M @ M ) ) ) ).

% le_cube
thf(fact_54_exists__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
    ? [A5: A] : ( member @ A @ A5 @ ( huffma505251170phabet @ A @ T ) ) ).

% exists_in_alphabet
thf(fact_55_le__le__imp__sum__mult__le__sum__mult,axiom,
    ! [I: nat,J: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ M @ N )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ N ) @ ( times_times @ nat @ J @ M ) ) @ ( plus_plus @ nat @ ( times_times @ nat @ I @ M ) @ ( times_times @ nat @ J @ N ) ) ) ) ) ).

% le_le_imp_sum_mult_le_sum_mult
thf(fact_56_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
         => ( B = C ) ) ) ).

% add_right_imp_eq
thf(fact_57_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
         => ( B = C ) ) ) ).

% add_left_imp_eq
thf(fact_58_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( plus_plus @ A @ B @ ( plus_plus @ A @ A2 @ C ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add.left_commute
thf(fact_59_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,B2: A] : ( plus_plus @ A @ B2 @ A3 ) ) ) ) ).

% add.commute
thf(fact_60_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
          = ( B = C ) ) ) ).

% add.right_cancel
thf(fact_61_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
          = ( B = C ) ) ) ).

% add.left_cancel
thf(fact_62_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add.assoc
thf(fact_63_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_64_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_65_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.left_commute
thf(fact_66_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% mult.commute
thf(fact_67_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.assoc
thf(fact_68_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_69_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_70_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_71_optimum__def,axiom,
    ! [A: $tType] :
      ( ( huffma936049440ptimum @ A )
      = ( ^ [T2: huffma16452318e_tree @ A] :
          ! [U2: huffma16452318e_tree @ A] :
            ( ( huffma1050891809istent @ A @ U2 )
           => ( ( ( huffma505251170phabet @ A @ T2 )
                = ( huffma505251170phabet @ A @ U2 ) )
             => ( ( ( huffma854352999e_freq @ A @ T2 )
                  = ( huffma854352999e_freq @ A @ U2 ) )
               => ( ord_less_eq @ nat @ ( huffma636208924e_cost @ A @ T2 ) @ ( huffma636208924e_cost @ A @ U2 ) ) ) ) ) ) ) ).

% optimum_def
thf(fact_72_cost__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B ) ) ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B ) ) ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
                  = ( huffma636208924e_cost @ A @ T ) ) ) ) ) ) ) ) ).

% cost_swapLeaves
thf(fact_73_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ X3 @ X3 ) ) ).

% order_refl
thf(fact_74_freq__uniteTrees,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma854352999e_freq @ A @ ( huffma453905539eTrees @ A @ T_1 @ T_2 ) )
      = ( ^ [A3: A] : ( plus_plus @ nat @ ( huffma854352999e_freq @ A @ T_1 @ A3 ) @ ( huffma854352999e_freq @ A @ T_2 @ A3 ) ) ) ) ).

% freq_uniteTrees
thf(fact_75_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ( A2 != B )
            & ( C != D ) )
          = ( ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) )
           != ( plus_plus @ A @ ( times_times @ A @ A2 @ D ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% crossproduct_noteq
thf(fact_76_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [W: A,Y: A,X3: A,Z: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ W @ Y ) @ ( times_times @ A @ X3 @ Z ) )
            = ( plus_plus @ A @ ( times_times @ A @ W @ Z ) @ ( times_times @ A @ X3 @ Y ) ) )
          = ( ( W = X3 )
            | ( Y = Z ) ) ) ) ).

% crossproduct_eq
thf(fact_77_combine__common__factor,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,E: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ E ) @ ( plus_plus @ A @ ( times_times @ A @ B @ E ) @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ E ) @ C ) ) ) ).

% combine_common_factor
thf(fact_78_distrib__right,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% distrib_right
thf(fact_79_distrib__left,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) ) ) ) ).

% distrib_left
thf(fact_80_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( ( comm_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% comm_semiring_class.distrib
thf(fact_81_swapLeaves__id__when__notin__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,W: nat,W2: nat] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma2094459102Leaves @ A @ T @ W @ A2 @ W2 @ A2 )
        = T ) ) ).

% swapLeaves_id_when_notin_alphabet
thf(fact_82_swapLeaves__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma2094459102Leaves @ A @ T @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 )
        = T ) ) ).

% swapLeaves_id
thf(fact_83_depth__swapLeaves__neither,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,C: A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( C != A2 )
       => ( ( C != B )
         => ( ( huffma223349076_depth @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) @ C )
            = ( huffma223349076_depth @ A @ T @ C ) ) ) ) ) ).

% depth_swapLeaves_neither
thf(fact_84_consistent__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) ) ).

% consistent_swapLeaves
thf(fact_85_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( A2 = B ) ) ) ) ).

% dual_order.antisym
thf(fact_86_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_87_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B: A] :
          ( ! [A5: A,B4: A] :
              ( ( ord_less_eq @ A @ A5 @ B4 )
             => ( P @ A5 @ B4 ) )
         => ( ! [A5: A,B4: A] :
                ( ( P @ B4 @ A5 )
               => ( P @ A5 @ B4 ) )
           => ( P @ A2 @ B ) ) ) ) ).

% linorder_wlog
thf(fact_88_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_89_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X3 @ Z ) ) ) ) ).

% order_trans
thf(fact_90_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( A2 = B ) ) ) ) ).

% order_class.order.antisym
thf(fact_91_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_92_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_93_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ( ord_less_eq @ A @ Y @ X3 )
         => ( ( ord_less_eq @ A @ X3 @ Y )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv
thf(fact_94_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X3 @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X3 )
             => ~ ( ord_less_eq @ A @ X3 @ Z ) )
           => ( ( ( ord_less_eq @ A @ X3 @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X3 ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X3 ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X3 )
                     => ~ ( ord_less_eq @ A @ X3 @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_95_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_96_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X3 @ Y )
         => ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% le_cases
thf(fact_97_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 = Y )
         => ( ord_less_eq @ A @ X3 @ Y ) ) ) ).

% eq_refl
thf(fact_98_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
          | ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% linear
thf(fact_99_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ X3 )
           => ( X3 = Y ) ) ) ) ).

% antisym
thf(fact_100_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y2: A,Z2: A] : ( Y2 = Z2 ) )
        = ( ^ [X: A,Y3: A] :
              ( ( ord_less_eq @ A @ X @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X ) ) ) ) ) ).

% eq_iff
thf(fact_101_ord__le__eq__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 @ ( type2 @ B3 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B: A,F: A > B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_102_ord__eq__le__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 @ ( type2 @ B3 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X2: B3,Y4: B3] :
                  ( ( ord_less_eq @ B3 @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_103_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B: A,F: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ C3 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_104_order__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 @ ( type2 @ B3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X2: B3,Y4: B3] :
                  ( ( ord_less_eq @ B3 @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_105_le__fun__def,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ( ( ord_less_eq @ ( A > B3 ) )
        = ( ^ [F2: A > B3,G2: A > B3] :
            ! [X: A] : ( ord_less_eq @ B3 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ) ).

% le_fun_def
thf(fact_106_le__funI,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3] :
          ( ! [X2: A] : ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( G @ X2 ) )
         => ( ord_less_eq @ ( A > B3 ) @ F @ G ) ) ) ).

% le_funI
thf(fact_107_le__funE,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3,X3: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funE
thf(fact_108_le__funD,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3,X3: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funD
thf(fact_109_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ D ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_110_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,C2: A] : ( plus_plus @ A @ C2 @ A3 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_111_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_112_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ C @ ( plus_plus @ A @ A2 @ D ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_113_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_114_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ D ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_115_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_116_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_117_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_118_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_119_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_120_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_121_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_122_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_123_swapSyms__def,axiom,
    ! [A: $tType] :
      ( ( huffma469337550apSyms @ A )
      = ( ^ [T2: huffma16452318e_tree @ A,A3: A,B2: A] : ( huffma2094459102Leaves @ A @ T2 @ ( huffma854352999e_freq @ A @ T2 @ A3 ) @ A3 @ ( huffma854352999e_freq @ A @ T2 @ B2 ) @ B2 ) ) ) ).

% swapSyms_def
thf(fact_124_ring__class_Oring__distribs_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% ring_class.ring_distribs(2)
thf(fact_125_ring__class_Oring__distribs_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) ) ) ) ).

% ring_class.ring_distribs(1)
thf(fact_126_semiring__normalization__rules_I34_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( times_times @ A @ X3 @ ( plus_plus @ A @ Y @ Z ) )
          = ( plus_plus @ A @ ( times_times @ A @ X3 @ Y ) @ ( times_times @ A @ X3 @ Z ) ) ) ) ).

% semiring_normalization_rules(34)
thf(fact_127_semiring__normalization__rules_I8_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% semiring_normalization_rules(8)
thf(fact_128_semiring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,M: A,B: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ M ) @ ( times_times @ A @ B @ M ) )
          = ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ M ) ) ) ).

% semiring_normalization_rules(1)
thf(fact_129_weight__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) ) @ ( huffma854352999e_freq @ A @ T @ B ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) @ W_b ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_b ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ B ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
                  = ( huffma691733767weight @ A @ T ) ) ) ) ) ) ) ) ).

% weight_swapLeaves
thf(fact_130_linordered__field__class_Osign__simps_I36_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) ) ) ) ).

% linordered_field_class.sign_simps(36)
thf(fact_131_linordered__field__class_Osign__simps_I35_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(35)
thf(fact_132_freq__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( huffma854352999e_freq @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
          = ( ^ [C2: A] : ( if @ nat @ ( C2 = A2 ) @ ( if @ nat @ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) ) @ W_a @ ( zero_zero @ nat ) ) @ ( if @ nat @ ( C2 = B ) @ ( if @ nat @ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) ) @ W_b @ ( zero_zero @ nat ) ) @ ( huffma854352999e_freq @ A @ T @ C2 ) ) ) ) ) ) ) ).

% freq_swapLeaves
thf(fact_133_exists__at__height,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( huffma1050891809istent @ A @ T )
     => ? [X2: A] :
          ( ( member @ A @ X2 @ ( huffma505251170phabet @ A @ T ) )
          & ( ( huffma223349076_depth @ A @ T @ X2 )
            = ( huffma1554076246height @ A @ T ) ) ) ) ).

% exists_at_height
thf(fact_134_sibling__swapLeaves__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,B: A,A2: A,W_a: nat,W_s: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ B )
         != B )
       => ( ( A2 != B )
         => ( ( huffma943100115ibling @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_s @ ( huffma943100115ibling @ A @ T @ B ) ) @ A2 )
            = B ) ) ) ) ).

% sibling_swapLeaves_sibling
thf(fact_135_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_136_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B ) )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_137_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
            = ( plus_plus @ A @ B @ A2 ) )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_138_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = A2 )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_139_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = A2 )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_140_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_141_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_142_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_143_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_144_mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ( times_times @ A @ A2 @ C )
            = ( times_times @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_right
thf(fact_145_mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( times_times @ A @ C @ A2 )
            = ( times_times @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_left
thf(fact_146_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% mult_eq_0_iff
thf(fact_147_mult__zero__right,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_right
thf(fact_148_mult__zero__left,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_left
thf(fact_149_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_150_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_151_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_152_mult__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ K )
        = ( times_times @ nat @ N @ K ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel2
thf(fact_153_mult__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel1
thf(fact_154_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times @ nat @ M @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% mult_0_right
thf(fact_155_mult__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% mult_is_0
thf(fact_156_notin__alphabet__imp__sibling__id,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% notin_alphabet_imp_sibling_id
thf(fact_157_sibling__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma943100115ibling @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = A2 ) ) ).

% sibling_sibling_id
thf(fact_158_height__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B: A] :
      ( ( huffma1554076246height @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
      = ( huffma1554076246height @ A @ T ) ) ).

% height_swapLeaves
thf(fact_159_add__le__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ B @ A2 ) @ B )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel1
thf(fact_160_add__le__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B ) @ B )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel2
thf(fact_161_le__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ A2 @ B ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% le_add_same_cancel1
thf(fact_162_le__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ B @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% le_add_same_cancel2
thf(fact_163_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_le_zero_iff_single_add_le_zero
thf(fact_164_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_le_double_add_iff_zero_le_single_add
thf(fact_165_notin__alphabet__imp__freq__0,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma854352999e_freq @ A @ T @ A2 )
        = ( zero_zero @ nat ) ) ) ).

% notin_alphabet_imp_freq_0
thf(fact_166_height__0__imp__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% height_0_imp_sibling_id
thf(fact_167_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma636208924e_cost @ A @ T )
        = ( zero_zero @ nat ) ) ) ).

% height_0_imp_cost_0
thf(fact_168_depth__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma223349076_depth @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = ( huffma223349076_depth @ A @ T @ A2 ) ) ) ).

% depth_sibling
thf(fact_169_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type2 @ A ) )
     => ! [X3: A] :
          ( ( ( zero_zero @ A )
            = X3 )
          = ( X3
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_170_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X3 ) ) ).

% zero_le
thf(fact_171_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ( plus_plus @ A @ X3 @ Y )
            = ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_172_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_173_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_174_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_175_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
            = ( plus_plus @ A @ B @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_176_semiring__normalization__rules_I5_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(5)
thf(fact_177_semiring__normalization__rules_I6_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(6)
thf(fact_178_mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C )
              = ( times_times @ A @ B @ C ) )
            = ( A2 = B ) ) ) ) ).

% mult_right_cancel
thf(fact_179_mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ C @ A2 )
              = ( times_times @ A @ C @ B ) )
            = ( A2 = B ) ) ) ) ).

% mult_left_cancel
thf(fact_180_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B
             != ( zero_zero @ A ) )
           => ( ( times_times @ A @ A2 @ B )
             != ( zero_zero @ A ) ) ) ) ) ).

% no_zero_divisors
thf(fact_181_divisors__zero,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
         => ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divisors_zero
thf(fact_182_mult__not__zero,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
           != ( zero_zero @ A ) )
         => ( ( A2
             != ( zero_zero @ A ) )
            & ( B
             != ( zero_zero @ A ) ) ) ) ) ).

% mult_not_zero
thf(fact_183_semiring__normalization__rules_I9_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(9)
thf(fact_184_semiring__normalization__rules_I10_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(10)
thf(fact_185_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_186_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_187_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% less_eq_nat.simps(1)
thf(fact_188_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq @ nat @ N @ ( zero_zero @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% le_0_eq
thf(fact_189_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( M = N ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_190_mult__0,axiom,
    ! [N: nat] :
      ( ( times_times @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% mult_0
thf(fact_191_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma943100115ibling @ A @ T @ A2 )
       != A2 )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% sibling_ne_imp_sibling_in_alphabet
thf(fact_192_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% in_alphabet_imp_sibling_in_alphabet
thf(fact_193_sibling__reciprocal,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ A2 )
          = B )
       => ( ( huffma943100115ibling @ A @ T @ B )
          = A2 ) ) ) ).

% sibling_reciprocal
thf(fact_194_add__decreasing,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ) ).

% add_decreasing
thf(fact_195_add__increasing,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ B @ ( plus_plus @ A @ A2 @ C ) ) ) ) ) ).

% add_increasing
thf(fact_196_add__decreasing2,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ) ).

% add_decreasing2
thf(fact_197_add__increasing2,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( ord_less_eq @ A @ B @ ( plus_plus @ A @ A2 @ C ) ) ) ) ) ).

% add_increasing2
thf(fact_198_add__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ B ) ) ) ) ) ).

% add_nonneg_nonneg
thf(fact_199_add__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% add_nonpos_nonpos
thf(fact_200_add__nonneg__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X3 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ Y )
           => ( ( ( plus_plus @ A @ X3 @ Y )
                = ( zero_zero @ A ) )
              = ( ( X3
                  = ( zero_zero @ A ) )
                & ( Y
                  = ( zero_zero @ A ) ) ) ) ) ) ) ).

% add_nonneg_eq_0_iff
thf(fact_201_add__nonpos__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ Y @ ( zero_zero @ A ) )
           => ( ( ( plus_plus @ A @ X3 @ Y )
                = ( zero_zero @ A ) )
              = ( ( X3
                  = ( zero_zero @ A ) )
                & ( Y
                  = ( zero_zero @ A ) ) ) ) ) ) ) ).

% add_nonpos_eq_0_iff
thf(fact_202_mult__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
             => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
               => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ) ) ).

% mult_mono
thf(fact_203_mult__mono_H,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
             => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
               => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ) ) ).

% mult_mono'
thf(fact_204_zero__le__square,axiom,
    ! [A: $tType] :
      ( ( linordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ A2 ) ) ) ).

% zero_le_square
thf(fact_205_split__mult__pos__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) ) )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ).

% split_mult_pos_le
thf(fact_206_mult__left__mono__neg,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% mult_left_mono_neg
thf(fact_207_mult__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ) ).

% mult_nonpos_nonpos
thf(fact_208_mult__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% mult_left_mono
thf(fact_209_mult__right__mono__neg,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% mult_right_mono_neg
thf(fact_210_mult__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% mult_right_mono
thf(fact_211_mult__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ) ) ).

% mult_le_0_iff
thf(fact_212_split__mult__neg__le,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) )
         => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ).

% split_mult_neg_le
thf(fact_213_mult__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ) ).

% mult_nonneg_nonneg
thf(fact_214_mult__nonneg__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonneg_nonpos
thf(fact_215_mult__nonpos__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonpos_nonneg
thf(fact_216_mult__nonneg__nonpos2,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ B @ A2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonneg_nonpos2
thf(fact_217_zero__le__mult__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_le_mult_iff
thf(fact_218_ordered__comm__semiring__class_Ocomm__mult__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere1490568538miring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% ordered_comm_semiring_class.comm_mult_left_mono
thf(fact_219_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [R: A,A2: A,B: A,C: A,D: A] :
          ( ( R
           != ( zero_zero @ A ) )
         => ( ( ( A2 = B )
              & ( C != D ) )
           => ( ( plus_plus @ A @ A2 @ ( times_times @ A @ R @ C ) )
             != ( plus_plus @ A @ B @ ( times_times @ A @ R @ D ) ) ) ) ) ) ).

% add_scale_eq_noteq
thf(fact_220_depth__le__height,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] : ( ord_less_eq @ nat @ ( huffma223349076_depth @ A @ T @ A2 ) @ ( huffma1554076246height @ A @ T ) ) ).

% depth_le_height
thf(fact_221_sum__squares__ge__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_ring @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) ) ) ) ).

% sum_squares_ge_zero
thf(fact_222_linordered__field__class_Osign__simps_I26_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(26)
thf(fact_223_linordered__field__class_Osign__simps_I27_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,B2: A] : ( plus_plus @ A @ B2 @ A3 ) ) ) ) ).

% linordered_field_class.sign_simps(27)
thf(fact_224_linordered__field__class_Osign__simps_I28_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( plus_plus @ A @ B @ ( plus_plus @ A @ A2 @ C ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(28)
thf(fact_225_linordered__field__class_Osign__simps_I23_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(23)
thf(fact_226_linordered__field__class_Osign__simps_I24_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% linordered_field_class.sign_simps(24)
thf(fact_227_linordered__field__class_Osign__simps_I25_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(25)
thf(fact_228_sum__squares__le__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) ) @ ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% sum_squares_le_zero_iff
thf(fact_229_height__0__imp__cachedWeight__eq__weight,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma787811817Weight @ A @ T )
        = ( huffma691733767weight @ A @ T ) ) ) ).

% height_0_imp_cachedWeight_eq_weight
thf(fact_230_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) )
            = ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% sum_squares_eq_zero_iff
thf(fact_231_depth__height__imp__sibling__ne,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma223349076_depth @ A @ T @ A2 )
          = ( huffma1554076246height @ A @ T ) )
       => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T ) )
         => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( huffma943100115ibling @ A @ T @ A2 )
             != A2 ) ) ) ) ) ).

% depth_height_imp_sibling_ne
thf(fact_232_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_233_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
          = ( ord_less @ A @ A2 @ B ) ) ) ).

% add_less_cancel_right
thf(fact_234_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
          = ( ord_less @ A @ A2 @ B ) ) ) ).

% add_less_cancel_left
thf(fact_235_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_236_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_237_add__less__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ B @ A2 ) @ B )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel1
thf(fact_238_add__less__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ B ) @ B )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel2
thf(fact_239_less__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ B ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% less_add_same_cancel1
thf(fact_240_less__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ B @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% less_add_same_cancel2
thf(fact_241_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_242_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_243_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_244_mult__less__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% mult_less_cancel2
thf(fact_245_nat__0__less__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( times_times @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% nat_0_less_mult_iff
thf(fact_246_nat__mult__less__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% nat_mult_less_cancel_disj
thf(fact_247_nat__mult__le__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% nat_mult_le_cancel_disj
thf(fact_248_mult__le__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% mult_le_cancel2
thf(fact_249_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X4: A] :
        ? [Y4: A] : ( ord_less @ A @ Y4 @ X4 ) ) ).

% linordered_field_no_lb
thf(fact_250_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X4: A] :
        ? [X1: A] : ( ord_less @ A @ X4 @ X1 ) ) ).

% linordered_field_no_ub
thf(fact_251_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_252_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_253_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero

%----Type constructors (38)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( preorder @ A7 @ ( type2 @ A7 ) )
     => ( preorder @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( order @ A7 @ ( type2 @ A7 ) )
     => ( order @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( ord @ A7 @ ( type2 @ A7 ) )
     => ( ord @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__monoid__add__imp__le,axiom,
    ordere516151231imp_le @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors__cancel,axiom,
    semiri1923998003cancel @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__comm__semiring,axiom,
    ordere1490568538miring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__semiring__0,axiom,
    ordered_semiring_0 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__semiring,axiom,
    ordered_semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring,axiom,
    semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_4,axiom,
    ! [A6: $tType] : ( preorder @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_5,axiom,
    ! [A6: $tType] : ( order @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_6,axiom,
    ! [A6: $tType] : ( ord @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_8,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $false @ X3 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $true @ X3 @ Y )
      = X3 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( plus_plus @ nat @ ( huffma636208924e_cost @ a @ ( huffma469337550apSyms @ a @ t @ a2 @ b ) ) @ ( plus_plus @ nat @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ a2 ) @ ( huffma223349076_depth @ a @ t @ a2 ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ b ) @ ( huffma223349076_depth @ a @ t @ b ) ) ) )
    = ( plus_plus @ nat @ ( huffma636208924e_cost @ a @ t ) @ ( plus_plus @ nat @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ a2 ) @ ( huffma223349076_depth @ a @ t @ b ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ a @ t @ b ) @ ( huffma223349076_depth @ a @ t @ a2 ) ) ) ) ) ).

%------------------------------------------------------------------------------
